/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.figuramc.figura.utils.FiguraText;

public class TextUtils {
    public static final Component TAB = FiguraText.of("tab");
    public static final Component ELLIPSIS = FiguraText.of("ellipsis");
    public static final Component UNKNOWN = Component.literal((String)"\ufffd").withStyle(Style.EMPTY.withFont(Style.DEFAULT_FONT));
    public static boolean allowScriptEvents;

    public static List<Component> splitText(FormattedText text, String regex) {
        ArrayList<Component> textList = new ArrayList<Component>();
        MutableComponent[] currentText = new MutableComponent[]{Component.empty()};
        text.visit((style, string) -> {
            String[] lines = string.split(regex, -1);
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    textList.add((Component)currentText[0].copy());
                    currentText[0] = Component.empty();
                }
                currentText[0].append((Component)Component.literal((String)lines[i]).withStyle(style));
            }
            return Optional.empty();
        }, Style.EMPTY);
        textList.add((Component)currentText[0]);
        return textList;
    }

    public static Component removeClickableObjects(FormattedText text) {
        return TextUtils.removeClickableObjects(text, p -> true);
    }

    public static Component removeClickableObjects(FormattedText text, Predicate<ClickEvent> pred) {
        MutableComponent ret = Component.empty();
        text.visit((style, string) -> {
            ret.append((Component)Component.literal((String)string).withStyle(style.getClickEvent() != null && pred.test(style.getClickEvent()) ? style.withClickEvent(null) : style));
            return Optional.empty();
        }, Style.EMPTY);
        return ret;
    }

    public static Component tryParseJson(String text) {
        MutableComponent finalText;
        if (text == null) {
            return Component.empty();
        }
        try {
            JsonParser.parseString((String)text);
            finalText = Component.Serializer.fromJsonLenient((String)text, (HolderLookup.Provider)RegistryAccess.EMPTY);
            if (finalText == null) {
                throw new Exception("Error parsing JSON string");
            }
        }
        catch (Exception ignored) {
            finalText = Component.literal((String)text);
        }
        return finalText;
    }

    public static Component replaceInText(FormattedText text, String regex, Object replacement) {
        return TextUtils.replaceInText(text, regex, replacement, (s, style) -> true, Integer.MAX_VALUE);
    }

    public static Component replaceInText(FormattedText text, String regex, Object replacement, BiPredicate<String, Style> predicate, int times) {
        return TextUtils.replaceInText(text, regex, replacement, predicate, 0, times);
    }

    public static Component replaceInText(FormattedText text, String regex, Object replacement, BiPredicate<String, Style> predicate, int beginIndex, int times) {
        MutableComponent mutableComponent;
        if (replacement instanceof Component) {
            Component c = (Component)replacement;
            mutableComponent = c;
        } else {
            mutableComponent = Component.literal((String)replacement.toString());
        }
        MutableComponent replace = mutableComponent;
        MutableComponent ret = Component.empty();
        int[] ints = new int[]{beginIndex, times};
        text.visit((arg_0, arg_1) -> TextUtils.lambda$replaceInText$4(predicate, ret, regex, ints, (Component)replace, arg_0, arg_1), Style.EMPTY);
        return ret;
    }

    public static Component trimToWidthEllipsis(Font font, Component text, int width, Component ellipsis) {
        if (font.width(text.getVisualOrderText()) <= width) {
            return text;
        }
        return TextUtils.addEllipsis(font, (FormattedText)text, width, ellipsis);
    }

    public static Component addEllipsis(Font font, FormattedText text, int width, Component ellipsis) {
        FormattedText trimmed = font.substrByWidth(text, width - font.width((FormattedText)ellipsis));
        return TextUtils.formattedTextToText(trimmed).copy().append(ellipsis);
    }

    public static Component replaceTabs(FormattedText text) {
        return TextUtils.replaceInText(text, "\\t", TAB);
    }

    public static List<FormattedCharSequence> wrapTooltip(FormattedText text, Font font, int mousePos, int screenWidth, int offset) {
        List<Component> splitText = TextUtils.splitText(text, "\n");
        int left = mousePos - offset;
        int right = screenWidth - mousePos - offset;
        int largest = TextUtils.getWidth(splitText, font);
        int side = largest <= right ? right : (largest <= left ? left : Math.max(left, right));
        return TextUtils.wrapText(text, side, font);
    }

    public static int getWidth(List<?> text, Font font) {
        int width = 0;
        for (Object object : text) {
            int w;
            if (object instanceof Component) {
                Component component = (Component)object;
                w = font.width((FormattedText)component);
            } else if (object instanceof FormattedCharSequence) {
                FormattedCharSequence charSequence = (FormattedCharSequence)object;
                w = font.width(charSequence);
            } else if (object instanceof String) {
                String s = (String)object;
                w = font.width(s);
            } else {
                w = 0;
            }
            width = Math.max(width, w);
        }
        return width;
    }

    public static int getHeight(List<?> text, Font font, int lineSpaceing) {
        int lines = text.size();
        Objects.requireNonNull(font);
        return lines * 9 + Math.max((lines - 1) * lineSpaceing, 0);
    }

    public static int getHeight(List<?> text, Font font) {
        return TextUtils.getHeight(text, font, 1);
    }

    public static Component replaceStyle(FormattedText text, Style newStyle, Predicate<Style> predicate) {
        MutableComponent ret = Component.empty();
        text.visit((style, string) -> {
            ret.append((Component)Component.literal((String)string).withStyle(predicate.test(style) ? newStyle.applyTo(style) : style));
            return Optional.empty();
        }, Style.EMPTY);
        return ret;
    }

    public static Component setStyleAtWidth(FormattedText text, int width, Font font, Style newStyle) {
        MutableComponent ret = Component.empty();
        text.visit((style, string) -> {
            MutableComponent current = Component.literal((String)string).withStyle(style);
            int prevWidth = font.width((FormattedText)ret);
            int currentWidth = font.width((FormattedText)current);
            if (prevWidth <= width && prevWidth + currentWidth > width) {
                current.withStyle(newStyle);
            }
            ret.append((Component)current);
            return Optional.empty();
        }, Style.EMPTY);
        return ret;
    }

    public static List<FormattedCharSequence> wrapText(FormattedText text, int width, Font font) {
        ArrayList<FormattedCharSequence> warp = new ArrayList<FormattedCharSequence>();
        font.getSplitter().splitLines(text, width, Style.EMPTY, (formattedText, aBoolean) -> warp.add(Language.getInstance().getVisualOrder(formattedText)));
        return warp;
    }

    public static Component charSequenceToText(FormattedCharSequence charSequence) {
        MutableComponent builder = Component.empty();
        StringBuilder buffer = new StringBuilder();
        Style[] lastStyle = new Style[1];
        charSequence.accept((index, style, codePoint) -> {
            if (!style.equals((Object)lastStyle[0])) {
                if (buffer.length() > 0) {
                    builder.append((Component)Component.literal((String)buffer.toString()).withStyle(lastStyle[0]));
                    buffer.setLength(0);
                }
                lastStyle[0] = style;
            }
            buffer.append(Character.toChars(codePoint));
            return true;
        });
        if (buffer.length() > 0) {
            builder.append((Component)Component.literal((String)buffer.toString()).withStyle(lastStyle[0]));
        }
        return builder;
    }

    public static Component formattedTextToText(FormattedText formattedText) {
        if (formattedText instanceof Component) {
            Component c = (Component)formattedText;
            return c;
        }
        MutableComponent builder = Component.empty();
        formattedText.visit((style, string) -> {
            builder.append((Component)Component.literal((String)string).withStyle(style));
            return Optional.empty();
        }, Style.EMPTY);
        return builder;
    }

    public static Component substring(FormattedText text, int beginIndex, int endIndex) {
        StringBuilder counter = new StringBuilder();
        MutableComponent builder = Component.empty();
        text.visit((style, string) -> {
            int index = counter.length();
            int len = string.length();
            if (index <= endIndex && index + len >= beginIndex) {
                int sub = Math.max(beginIndex - index, 0);
                int top = Math.min(endIndex - index, len);
                builder.append((Component)Component.literal((String)string.substring(sub, top)).withStyle(style));
            }
            counter.append(string);
            return counter.length() > endIndex ? FormattedText.STOP_ITERATION : Optional.empty();
        }, Style.EMPTY);
        return builder;
    }

    public static Component parseLegacyFormatting(FormattedText text) {
        MutableComponent builder = Component.empty();
        text.visit((style, string) -> {
            String[] split;
            if (string.contains("\u00a7") && (split = string.split("\u00a7")).length >= 2) {
                MutableComponent newText = Component.literal((String)split[0]).withStyle(style);
                for (int i = 1; i < split.length; ++i) {
                    String s = split[i];
                    if (s.length() == 0) continue;
                    ChatFormatting formatting = ChatFormatting.getByCode((char)s.charAt(0));
                    if (formatting != null) {
                        style = style.applyLegacyFormat(formatting);
                    }
                    newText.append((Component)Component.literal((String)s.substring(1)).withStyle(style));
                }
                builder.append((Component)newText);
                return Optional.empty();
            }
            builder.append((Component)Component.literal((String)string).withStyle(style));
            return Optional.empty();
        }, Style.EMPTY);
        return builder;
    }

    public static Component reverse(FormattedText text) {
        MutableComponent[] builder = new MutableComponent[]{Component.empty()};
        text.visit((style, string) -> {
            StringBuilder str = new StringBuilder(string).reverse();
            builder[0] = Component.literal((String)str.toString()).withStyle(style).append((Component)builder[0]);
            return Optional.empty();
        }, Style.EMPTY);
        return builder[0];
    }

    public static Component trim(FormattedText text) {
        int start;
        String string = text.getString();
        int end = string.length();
        for (start = 0; start < end && string.charAt(start) <= ' '; ++start) {
        }
        while (start < end && string.charAt(end - 1) <= ' ') {
            --end;
        }
        return TextUtils.substring(text, start, end);
    }

    public static List<Component> formatInBounds(FormattedText text, Font font, int maxWidth, boolean wrap) {
        if (maxWidth > 0) {
            if (wrap) {
                List<FormattedCharSequence> warped = TextUtils.wrapText(text, maxWidth, font);
                ArrayList<Component> newList = new ArrayList<Component>();
                for (FormattedCharSequence charSequence : warped) {
                    newList.add(TextUtils.charSequenceToText(charSequence));
                }
                return newList;
            }
            List<Component> list = TextUtils.splitText(text, "\n");
            ArrayList<Component> newList = new ArrayList<Component>();
            for (Component component : list) {
                newList.add(TextUtils.formattedTextToText(font.substrByWidth((FormattedText)component, maxWidth)));
            }
            return newList;
        }
        return TextUtils.splitText(text, "\n");
    }

    private static /* synthetic */ Optional lambda$replaceInText$4(BiPredicate predicate, MutableComponent ret, String regex, int[] ints, Component replace, Style style, String string) {
        String[] split;
        if (!predicate.test(string, style)) {
            ret.append((Component)Component.literal((String)string).withStyle(style));
            return Optional.empty();
        }
        for (String s : split = string.split("((?<=" + regex + ")|(?=" + regex + "))")) {
            if (!s.matches(regex)) {
                ret.append((Component)Component.literal((String)s).withStyle(style));
                continue;
            }
            if (ints[0] > 0 || ints[1] <= 0) {
                ret.append((Component)Component.literal((String)s).withStyle(style));
            } else {
                ret.append((Component)Component.empty().withStyle(style).append(replace));
            }
            ints[0] = ints[0] - 1;
            ints[1] = ints[1] - 1;
        }
        return Optional.empty();
    }

    public static class FiguraClickEvent
    extends ClickEvent {
        public final Runnable onClick;

        public FiguraClickEvent(Runnable onClick) {
            super(ClickEvent.Action.SUGGEST_COMMAND, "");
            this.onClick = onClick;
        }
    }

    public static enum Alignment {
        LEFT((font, component) -> 0, i -> 0),
        RIGHT((font, component) -> font.width(component), i -> i),
        CENTER((font, component) -> font.width(component) / 2, i -> i / 2);

        private final BiFunction<Font, FormattedText, Integer> textFunction;
        private final Function<Integer, Integer> integerFunction;

        private Alignment(BiFunction<Font, FormattedText, Integer> textFunction, Function<Integer, Integer> integerFunction) {
            this.textFunction = textFunction;
            this.integerFunction = integerFunction;
        }

        public int apply(Font font, FormattedText component) {
            return this.textFunction.apply(font, component);
        }

        public int apply(int width) {
            return this.integerFunction.apply(width);
        }
    }
}

